# -*- coding: utf-8 -*-
"""
Created on Thu Apr 29 11:57:02 2021

@author: Dyrvik
"""
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import matplotlib as mpl
import seaborn as sns
import pandas as pd
import os
from mpl_toolkits.axes_grid1 import Divider, Size

"""Colourmaps"""
CM_SUBSECTION_GREENS = np.linspace(0.4, 1.0, 1000) 
COLOURS_GREENS = [ cm.Greens(x) for x in CM_SUBSECTION_GREENS ]

CM_SUBSECTION_ORANGES = np.linspace(0.3, 1.0, 1000) 
COLOURS_ORANGES = [ cm.Oranges(x) for x in CM_SUBSECTION_ORANGES ]

CM_SUBSECTION_BLUES = np.linspace(0.3, 1.0, 1000) 
COLOURS_BLUES = [ cm.Blues(x) for x in CM_SUBSECTION_BLUES ]

"""File handling"""
main_folder_path = os.path.dirname(os.path.abspath(__file__))
main_folder_path = '\\\\?\\' + main_folder_path
data_folder_name = 'Selected files'
data_folder_path = os.path.join(main_folder_path,data_folder_name)
export_folder_path = main_folder_path
# =============================================================================
# export_folder_name = 'Plots'
# export_folder_path = os.path.join(main_folder_path,export_folder_name)
# if not os.path.exists(export_folder_path):
#     os.mkdir(export_folder_path) # create folder if non-existent
# =============================================================================
    
selected_files = ['dyrvik_IGLED19-Batch11_003223-reverse_6_1.ilv', \
                 'dyrvik_IGLED19-Batch11_003224-normal_8_4.ilv', \
                 'dyrvik_IGLED19-Batch11_003225-normal_8_3.ilv']

"""Some constants for graphical settings"""
lw = 3
ticksize_major = 8
ticksize_minor = 8  

"""Prepare plots"""
label_strings = ['A',\
                 'B',\
                 'C'] 
    
label_strings_twin = ['A',\
                 'B',\
                 'C']  
                                              
colour_array =  np.linspace(0, 999, len(selected_files))

fig = plt.figure(figsize=(7.5, 7.5))
h = [Size.Fixed(1.0), Size.Scaled(1.), Size.Fixed(.2)]
v = [Size.Fixed(0.7), Size.Scaled(1.), Size.Fixed(.5)]
divider = Divider(fig, (0, 0, 1, 1), h, v, aspect=False)
# The width and height of the rectangle are ignored.
ax = plt.axes([0.15, 0.15, 0.85, 0.85])
ax_twin = ax.twinx()
ax.set_xlabel('Bias [V]')
ax.set_ylabel('Current Density [$\mathregular{mA/cm^2}$]')
ax_twin.set_ylabel('Luminance [$\mathregular{cd/m^2}$]')

"""Plot the data"""
for i in range(len(selected_files)):
    """Load data, turn the sign and remove negatives to allow log-plots"""
    file_path = os.path.join(data_folder_path,selected_files[i])
    df = pd.read_csv(file_path, delimiter='\t')
    
    ax.semilogy(df['LED voltage [V]'], df['LED current [mA/cm2]'], color=COLOURS_GREENS[np.int(colour_array[i])], label=label_strings[i])
    ax_twin.semilogy(df['LED voltage [V]'], df['Luminance [cd/m2]'], marker='s', markersize=3.5*lw, markevery=0.1, color=COLOURS_BLUES[np.int(colour_array[i])], label=label_strings_twin[i])

# =============================================================================
# """Annotation"""
# label_i = '(i) ITO/$\mathrm{Al_2O_3}$/LiF/...'
# label_ii = '(ii) ITO/$\mathrm{Al_2O_3}$/TFB/LiF/...'
# label_iii = '(iii) ITO/TFB/$\mathrm{Al_2O_3}$/LiF/...'
# label_text = label_i + '\n' + label_ii + '\n' + label_iii
# ax.text(1.15, 0.15, label_text,
#         horizontalalignment='left',
#         verticalalignment='top',
#         transform=ax.transAxes)
# =============================================================================
# =============================================================================
# ax.annotate("",
#             xy=(0.106, 0.45), xycoords='axes fraction',
#             xytext=(0.256, 0.45), textcoords='axes fraction',
#             arrowprops=dict(facecolor='black', width=lw),
#             )
# ax.annotate("",
#             xy=(0.473, 0.2), xycoords='axes fraction',
#             xytext=(0.323, 0.2), textcoords='axes fraction',
#             arrowprops=dict(facecolor='black', width=lw),
#             )
# 
# =============================================================================
"""Axis settings"""
ax.set_xlim(left=2.5)
ax.set_ylim(bottom=1e-5, top=2.5e1)
ax_twin.set_ylim(bottom=1e-2, top=2e4)
ax.xaxis.set_major_locator(mpl.ticker.MultipleLocator(0.5))
ax.xaxis.set_minor_locator(mpl.ticker.MultipleLocator(0.1))

"""Legend"""
leg = ax.legend(title='Current d.',loc='upper left',frameon = False)
leg_twin = ax_twin.legend(title='Luminance',loc='lower right', frameon = False)

# Right-aligning the legend
vp = leg_twin._legend_box._children[-1]._children[0]
for c in vp._children:
    c._children.reverse()
vp.align="right"

"""Graphical details"""
plt.rcParams['font.size'] = 24
plt.rc('axes', labelsize=30)    # fontsize of the x and y labels
plt.rcParams['axes.linewidth'] = lw
plt.rcParams['lines.linewidth'] = lw*1.5

ax.xaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.xaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
ax.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
ax_twin.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax_twin.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)


"""Exporting plots"""
plot_name = 'Plot JVL Other Configs'
export_name_pdf = plot_name + '.pdf'
export_name_svg = plot_name + '.svg'
#export_name_eps = plot_name + '.eps'
pdf_path = os.path.join(export_folder_path,export_name_pdf)
svg_path = os.path.join(export_folder_path,export_name_svg)
#eps_path = os.path.join(export_folder_path,export_name_eps)
if len(pdf_path) > 255:
    warning_string = 'Warning: plot file path longer than 255 characters, downstream handling issues may occur. Path: ' + pdf_path
    print(warning_string)
fig.savefig(pdf_path, bbox_inches='tight')
fig.savefig(svg_path, bbox_inches='tight')
#fig.savefig(eps_path, bbox_inches='tight')
plt.close(fig)

